Sys.setlocale(category="LC_ALL", "")#locale = "English_United States.1252")
local({
	Dir<- paste0(Sys.getenv("USERPROFILE"),"\\Documents")
	if(!file.exists(Dir)){ 
		dir.create(Dir, recursive=T)
		Sys.setenv(R_USER=Dir)
	}
	Dir.lib<- Sys.getenv("R_LIBS_USER")
	###
	pk.dir<- paste(getwd(),"/Rpackages",sep="")
	.libPaths(c(pk.dir, .libPaths()))
	if(file.exists(Sys.getenv("R_LIBS_USER"))).libPaths(c(Sys.getenv("R_LIBS_USER"), .libPaths()))
	item<- c("data.table","plotrix","rms","Hmisc","lokern","namespace") 
	dir.user<- NULL
	item.not<- NULL
	for(pk.i in item){
		pk.lib<- find.package(pk.i, quiet=T)
		if(length(pk.lib)==0){
			if(is.null(dir.user)){
				cat("\nYou must have an internet connection to install ", pk.i," package.\n",sep="")
				NextRun<- menu(c("Yes","No"), title="=> Do you have an active internet connection?")
				if(NextRun != 1){
					unlink("RFirst")
					stop(paste("... can not continue to download and install ",pk.i," package.",sep=""), call.=FALSE)
				}
				else{
					cat("... continue to download R packages and install.\n")
					dir.user<- pk.dir #Sys.getenv("R_LIBS_USER")
				}
			}
			if(pk.i == "namespace"){
				pk.i2<- list.files(dir.user)
				pk.i2<- pk.i2[grep("tar.gz", pk.i2)]
				if(length(pk.i2)>0){
					pk.i2<- pk.i2[grep("namespace", pk.i2)]
					if(length(pk.i2)>0){
						pk.i2<- paste0(dir.user, "/", pk.i2[1])
						install.packages(pk.i2, lib=dir.user, dependencies=FALSE, clean=TRUE, type="source")
					}
				}
			}
			else{ install.packages(pk.i, lib=dir.user, dependencies=FALSE, clean=TRUE, type="win.binary") }
		}
		pk.lib<- find.package(pk.i, quiet=T)
		if(length(pk.lib)==0){ item.not<- c(item.not, pk.i) }
	}
	n.item.not<- length(item.not)
	if(n.item.not >0){
		if(n.item.not==1) stop(paste0("... \nThe package: ",item.not,"\n    was not successfully installed."))
		else stop(paste0("... \nThe packages: ",paste0(item.not, collapse=","),"\n    were not successfully installed."))
	}
	if(length(find.package("iSQoL2", quiet=T, lib.loc=pk.dir))==0)stop(paste("... iSQoL2 is not included in",pk.dir), call.=FALSE)

	require(iSQoL2, quietly=FALSE, lib.loc=pk.dir)
	if(scan("RFirst", what="",quiet=T, n=1)=="OK"){
		GetMenu()
		cat("* The temporary folder '.iSQoL2' is created in",Sys.getenv("R_USER"),".\n\n")
	}else{ 
		source("RFirst");save(list=".First", file=".RData", compress=T)
		cat("=> Quit R and then restart R to update settings.\n")
	}
})	
unlink("RFirst")
